(t=>{"use strict";var e=Kucs["1.22.0"];const n={template:'\n         <div class="manulet-config">\n         <div class="block">\n            <div class="header-section">\n                <div class="header-content">\n                    <h2>manulet認証設定</h2>\n                    <p>このプラグインをご利用いただくには認証トークンが必要です。</p>\n                </div>\n                <div class="header-actions">\n                    <div v-if="suggestedToken" class="suggested-token-box">\n                        <p><strong>ドメイン内で見つかった有効なトークン:</strong></p>\n                        <div class="token-display">\n                            <code>{{suggestedToken}}</code>\n                            <button\n                                type="button"\n                                @click="copyToken(suggestedToken)"\n                                class="kintoneplugin-button-normal copy-button"\n                                title="コピー"\n                            >\n                                📋 コピー\n                            </button>\n                        </div>\n                        <p class="token-hint">※ このトークンを使用する場合は、上記の認証トークン欄に貼り付けてください</p>\n                    </div>\n                    <button\n                        type="button"\n                        @click="testAuthentication"\n                        :disabled="isTestingAuth"\n                        class="kintoneplugin-button-normal test-button"\n                    >\n                        {{isTestingAuth ? \'接続テスト中...\' : \'接続テスト\'}}\n                    </button>\n                </div>\n            </div>\n         </div>\n         <hr>\n\n         \x3c!-- 認証設定セクション --\x3e\n         <div class="block">\n            <h3>認証設定</h3>\n         </div>\n         <div class="block">\n            <label class="kintoneplugin-label">\n                <span id="auth-token-label">認証トークン</span>\n            </label>\n            <div class="kintoneplugin-row">\n                <p>契約時に発行された32文字の認証トークンを入力してください。</p>\n                <input\n                    class="kintoneplugin-input-text"\n                    id="auth-token"\n                    v-model="authToken"\n                    placeholder="32文字の英数字"\n                    maxlength="32"\n                    pattern="[a-zA-Z0-9]{32}"\n                    @input="validateAuthToken"\n                />\n                <div v-if="authTokenError" class="error-message">{{authTokenError}}</div>\n            </div>\n         </div>\n\n         \x3c!-- 認証状況表示 --\x3e\n         <div class="block" v-if="authStatus">\n            <label class="kintoneplugin-label">認証状況</label>\n            <div class="kintoneplugin-row">\n                <div class="auth-status" :class="authStatusClass">\n                    <div class="status-indicator" :class="authStatusClass"></div>\n                    <span>{{authStatusText}}</span>\n                </div>\n                <div v-if="authInfo" class="auth-details">\n                    <p><strong>契約種別:</strong> {{getAuthStatusLabel(authInfo.auth_status)}}</p>\n                    <p><strong>アプリ制限:</strong> {{authInfo.app_details ? authInfo.app_details.length : 0}} / {{authInfo.app_limit}}</p>\n                    <p v-if="authInfo.expiry_date && authInfo.expiry_date !== \'3000-12-31\'">\n                        <strong>有効期限:</strong> {{authInfo.expiry_date}}\n                    </p>\n                </div>\n            </div>\n         </div>\n\n         \x3c!-- 登録済みアプリ一覧 --\x3e\n         <div class="block" v-if="authInfo && authInfo.app_details && authInfo.app_details.length > 0">\n            <label class="kintoneplugin-label">登録済みアプリ一覧（{{authInfo.app_details.length}} / {{authInfo.app_limit}}）</label>\n            <div class="kintoneplugin-row">\n                <div id="app-table-container"></div>\n                <div class="app-list-note">\n                    <p>※ 現在のアプリ（ID: {{currentAppId}}）は削除できません</p>\n                    <p>※ アプリを削除後に再度そのアプリでプラグインを使用すると自動的に再登録されます</p>\n                </div>\n            </div>\n         </div>\n\n         \n         <br><br>\n            <div class = "block">\n                <button type="button" @click="doCancel" id = "check-plugin-cancel" class = "kintoneplugin-button-dialog-cancel">　Cancel　</button>\n                <button type= "button" @click= "doSubmit" id = "check-plugin-submit" class = "kintoneplugin-button-dialog-ok">　Save　</button>\n            </div>\n\n         ',data:()=>({authToken:"",authTokenError:"",authStatus:"",authStatusText:"",authStatusClass:"",authInfo:null,isTestingAuth:!1,currentAppId:kintone.app.getId(),authApiUrl:"https://gibbons-de.org/manulet_plugin2025/auth/auth.php",appTable:null,suggestedToken:""}),methods:{doCancel(){history.back()},validateAuthToken(){const t=this.authToken.trim();t?/^[a-zA-Z0-9]{32}$/.test(t)?this.authTokenError="":this.authTokenError="32文字の英数字を入力してください":this.authTokenError=""},getAuthStatusLabel:t=>({unauthenticated:"無償版",single_app_limited:"無料版（単一アプリ制限）",monthly:"月額契約",yearly:"年額契約",perpetual:"買い切り",partner:"パートナー",support:"伴走支援"}[t]||t),async callAuthAPI(t){let e;try{e=window.location.hostname;const t="undefined"!=typeof kintone&&kintone.getDomain?kintone.getDomain():null;if(t)try{if("function"==typeof t.then){const n=await t;n&&n.subDomain&&n.baseDomain&&(e=`${n.subDomain}.${n.baseDomain}`)}else t.subDomain&&t.baseDomain&&(e=`${t.subDomain}.${t.baseDomain}`)}catch(t){console.warn("kintone.getDomain() failed, using window.location.hostname:",t)}if(!e||"undefined"===e||!e.includes("."))throw new Error("Cannot determine valid domain")}catch(t){console.error("Domain detection failed:",t),e=window.location.hostname||"fallback.cybozu.com"}console.log("Detected domain:",e);const n={domain:e,app_id:this.currentAppId,auth_token:t||"",plugin_version:"1.2.3",user_agent:navigator.userAgent,timestamp:(new Date).toISOString()};try{const t=await fetch(this.authApiUrl,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)}),e=await t.json();return console.log("=== Auth API Debug ==="),console.log("HTTP Status:",t.status),console.log("Response OK:",t.ok),console.log("Response Data:",e),console.log("Request Data:",n),console.log("====================="),t.ok&&"success"===e.status?{success:!0,data:e.data}:{success:!1,error:e.message||"API呼び出しに失敗しました"}}catch(t){return console.error("Auth API Error:",t),{success:!1,error:"ネットワークエラーが発生しました"}}},async testAuthentication(){this.isTestingAuth=!0,this.authStatus="testing",this.authStatusText="接続テスト中...",this.authStatusClass="testing";try{const t=await this.callAuthAPI(this.authToken);t.success?(this.authStatus="success",this.authInfo=t.data,this.suggestTokenFromOtherApps(),this.showToast(`接続テスト成功: ${this.getStatusLabel(t.data.auth_status)}`,"success"),this.$nextTick(()=>{this.updateAppTable()}),"single_app_limited"===t.data.auth_status?(this.authStatusText="無料版（単一アプリ制限）",this.authStatusClass="success"):"unauthenticated"===t.data.auth_status?(this.authStatusText="未認証（複数アプリ検出）",this.authStatusClass="success"):(this.authStatusText="認証成功",this.authStatusClass="success")):(this.authStatus="error",this.authStatusText=t.error,this.authStatusClass="error",this.authInfo=null,this.showToast(`接続テスト失敗: ${t.error}`,"error"))}catch(t){console.error("[DEBUG] testAuthentication error:",t),console.error("[DEBUG] Error stack:",t.stack),this.authStatus="error",this.authStatusText="システムエラーが発生しました",this.authStatusClass="error",this.authInfo=null}finally{this.isTestingAuth=!1}},suggestTokenFromOtherApps(){console.log("=== suggestTokenFromOtherApps Debug ==="),console.log("authInfo:",this.authInfo),console.log("app_list:",this.authInfo?.app_list),console.log("app_list length:",this.authInfo?.app_list?.length);const e=kintone.plugin.app.getConfig(t).auth_token||"";if(e&&32===e.length)return console.log("Valid saved token exists, skipping auto-suggestion"),console.log("Saved token:",e.substring(0,8)+"..."),!1;if(!this.authInfo||!this.authInfo.app_details||0===this.authInfo.app_details.length)return console.log("No app_list available"),!1;for(const t of this.authInfo.app_details)if(console.log("Checking app:",t.app_id,"is_rogue:",t.is_rogue,"auth_token:",t.auth_token),!t.is_rogue&&t.auth_token&&32===t.auth_token.length)return console.log("Found valid token from app:",t.app_id,"Token:",t.auth_token),this.suggestedToken!==t.auth_token&&(this.suggestedToken=t.auth_token,console.log("Suggested token set from domain:",t.auth_token.substring(0,8)+"...")),!0;return console.log("No valid token found in domain"),this.suggestedToken="",!1},async deleteApp(t){if(t!==this.currentAppId)try{let e;try{if(e=window.location.hostname,"undefined"!=typeof kintone&&kintone.getDomain)try{const t=kintone.getDomain();if(t&&"function"==typeof t.then){const n=await t;n&&n.subDomain&&n.baseDomain&&(e=`${n.subDomain}.${n.baseDomain}`)}else t&&t.subDomain&&t.baseDomain&&(e=`${t.subDomain}.${t.baseDomain}`)}catch(t){console.warn("kintone.getDomain() failed, using window.location.hostname:",t)}}catch(t){console.error("Domain detection failed:",t),e=window.location.hostname||"fallback.cybozu.com"}const n={domain:e,app_id:t,auth_token:this.authToken,plugin_version:"1.2.3",user_agent:navigator.userAgent,timestamp:(new Date).toISOString(),action:"delete_app"};console.log("Delete API Request Data:",n);const o=await fetch(this.authApiUrl,{method:"POST",headers:{"Content-Type":"application/json"},body:JSON.stringify(n)});if(console.log("Delete API Response Status:",o.status),console.log("Delete API Response OK:",o.ok),!o.ok){const t=await o.text();throw console.error("Delete API Error Response:",t),new Error(`HTTP Error: ${o.status} - ${t}`)}const s=await o.json();if(console.log("Delete API Response Data:",s),"success"===s.status)return!0;throw console.error("App deletion failed:",s.message),new Error(s.message||"App deletion failed")}catch(t){throw console.error("App deletion error:",t),t}},formatDate(t){if(!t)return"-";try{return new Date(t).toLocaleDateString("ja-JP",{year:"numeric",month:"2-digit",day:"2-digit",hour:"2-digit",minute:"2-digit"})}catch(t){return"-"}},getStatusLabel:t=>({single_app_limited:"無料版",monthly:"月額契約",yearly:"年額契約",perpetual:"買い切り",partner:"パートナー",support:"伴走支援",unauthenticated:"未認証",unknown:"不明"}[t]||"不明"),updateAppTable(){if(!this.authInfo||!this.authInfo.app_details||0===this.authInfo.app_details.length){const t=document.getElementById("app-table-container");return void(t&&(t.innerHTML="<p>登録済みアプリがありません</p>"))}const t=document.getElementById("app-table-container");if(!t)return;t.innerHTML="";const n=this.authInfo.app_details.map(t=>{const e=t.app_id==this.currentAppId;let n="";return n=t.is_rogue?"未認証":"single_app_limited"===t.token_status?"認証済み（無料版）":"認証済み",{app_id:e?`${t.app_id} (現在)`:t.app_id.toString(),status:n,version:`v${t.plugin_version||"unknown"}`,last_access:this.formatDate(t.last_access),action:"",_isCurrentApp:e,_rawAppId:t.app_id}});this.appTable=new e.Table({columns:[{title:"アプリID",field:"app_id"},{title:"ステータス",field:"status"},{title:"バージョン",field:"version"},{title:"最終アクセス",field:"last_access"},{title:"操作",field:"action"}],data:n,actionButton:!1,headerVisible:!0,visible:!0}),t.appendChild(this.appTable),setTimeout(()=>{this.addDeleteButtonsToTable()},100)},addDeleteButtonsToTable(){if(!this.appTable||!this.authInfo||!this.authInfo.app_details)return;const t=this.appTable.querySelectorAll("tbody tr");this.authInfo.app_details.forEach((e,n)=>{const o=e.app_id==this.currentAppId,s=t[n];if(!s)return;const a=s.querySelectorAll("td"),i=a[a.length-1];if(i)if(i.innerHTML="",i.style.textAlign="center",i.style.padding="8px",o)i.textContent="-",i.style.color="#999";else{const t=document.createElement("button");t.textContent="削除",t.type="button",t.style.cssText="\n                            background-color: #dc3545;\n                            color: white;\n                            padding: 4px 12px;\n                            border: none;\n                            border-radius: 3px;\n                            cursor: pointer;\n                            font-size: 11px;\n                            line-height: 1.4;\n                            transition: background-color 0.2s;\n                        ",t.addEventListener("mouseenter",()=>{t.style.backgroundColor="#c82333"}),t.addEventListener("mouseleave",()=>{t.style.backgroundColor="#dc3545"}),t.addEventListener("click",async()=>{await this.handleDeleteApp(e.app_id)}),i.appendChild(t)}})},async handleDeleteApp(t){console.log("handleDeleteApp called for:",t);if(confirm(`アプリID ${t} を登録から削除しますか？\n\n【重要】削除しても、そのアプリでプラグインを使用すると自動的に再登録されます。\n完全に削除するには、Kintoneアプリ側でプラグインを無効化してください。\n\n削除を続行しますか？`))try{console.log("Confirmed delete, calling deleteApp for:",t);const e=await this.deleteApp(t);if(console.log("Delete result:",e),!0!==e)throw new Error("Delete operation returned false");console.log("App deleted successfully, refreshing auth info..."),this.showToast(`アプリID ${t} を削除しました`,"success"),await this.testAuthentication(),console.log("Auth info refreshed after deletion"),this.updateAppTable()}catch(t){console.error("Failed to delete app:",t),alert("アプリの削除に失敗しました。もう一度お試しください。"),this.showToast("アプリの削除に失敗しました","error")}else console.log("Delete cancelled by user")},hideCurrentAppDeleteButton(){if(!this.appTable||!this.authInfo||!this.authInfo.app_details)return;console.log("hideCurrentAppDeleteButton called, currentAppId:",this.currentAppId);const t=this.appTable.querySelectorAll("tbody tr, .kuc-table__body tr");console.log("Found rows:",t.length,"apps:",this.authInfo.app_details.length),this.authInfo.app_details.forEach((e,n)=>{const o=e.app_id==this.currentAppId;if(console.log(`App ${n}: ID=${e.app_id}, isCurrent=${o}`),o&&t[n]){console.log(`Hiding delete button for current app: ${e.app_id} at row index: ${n}`),t[n].classList.add("current-app-row"),t[n].setAttribute("data-current-app","true");const o=t[n].querySelectorAll("button");console.log(`Found ${o.length} buttons in current app row`),o.forEach((t,e)=>{console.log(`Button ${e}:`,t.textContent,t.className),t.style.display="none",t.style.visibility="hidden",t.disabled=!0})}})},showToast(t,e="info"){const n=document.createElement("div");n.className=`toast toast-${e}`,n.textContent=t,n.style.cssText="\n                     position: fixed;\n                     top: 20px;\n                     right: 20px;\n                     padding: 12px 20px;\n                     border-radius: 4px;\n                     color: white;\n                     font-weight: bold;\n                     z-index: 10000;\n                     opacity: 0;\n                     transition: opacity 0.3s ease;\n                 ";const o={success:"#28a745",error:"#dc3545",warning:"#ffc107",info:"#17a2b8"};n.style.backgroundColor=o[e]||o.info,document.body.appendChild(n),setTimeout(()=>{n.style.opacity="1"},100),setTimeout(()=>{n.style.opacity="0",setTimeout(()=>{document.body.removeChild(n)},300)},3e3)},copyToken(t){if(navigator.clipboard&&navigator.clipboard.writeText)navigator.clipboard.writeText(t).then(()=>{this.showToast("トークンをクリップボードにコピーしました","success")}).catch(t=>{console.error("クリップボードへのコピーに失敗:",t),this.showToast("コピーに失敗しました","error")});else{const e=document.createElement("textarea");e.value=t,e.style.position="fixed",e.style.opacity="0",document.body.appendChild(e),e.select();try{document.execCommand("copy"),this.showToast("トークンをクリップボードにコピーしました","success")}catch(t){console.error("クリップボードへのコピーに失敗:",t),this.showToast("コピーに失敗しました","error")}document.body.removeChild(e)}},doSubmit(){if(console.log("doSubmit called"),console.log("authTokenError:",this.authTokenError),console.log("authToken:",this.authToken),this.authTokenError)return void alert("認証トークンの形式が正しくありません");const e={auth_token:this.authToken.trim(),auth_api_url:this.authApiUrl,last_updated:(new Date).toISOString()};console.log("Saving config:",e),console.log("PLUGIN_ID:",t);try{kintone.plugin.app.setConfig(e),console.log("setConfig called successfully")}catch(t){console.error("Error calling setConfig:",t),alert("設定の保存に失敗しました: "+t.message)}}},mounted(){const e=kintone.plugin.app.getConfig(t);e.auth_token&&(this.authToken=e.auth_token),e.auth_api_url&&(this.authApiUrl=e.auth_api_url),setTimeout(()=>{this.testAuthentication()},500)}},{createApp:o}=Vue;o({components:{"config-page":n}}).mount("#manuletconfig")})(kintone.$PLUGIN_ID);